<?php
error_reporting(E_ALL);

require_once 'vendor/autoload.php';

try {
    $dsn = 'mysql:host=localhost;dbname=erp;charset=utf8';
    $conn = new PDO($dsn, 'geraldo', 'odlareg');
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

$id_chamado = $_GET['id'] ?? null;

// Consulta o cabeçalho do chamado
$sql_cabecalho = "SELECT id AS chamado,
     DATE_FORMAT(dt_cad, '%d/%m/%Y') AS dt,
     (SELECT nome_rs FROM cliente WHERE id = fk_cliente) AS Cliente,
     cliente_solicitante,
     serie,
     maquina,
     setor,
     endereco,
     cidade,
     uf,
     (SELECT descricao FROM servico_tipo WHERE id = fk_servico_tipo) tipo,
     (SELECT descricao FROM servico WHERE id = fk_servico) servico,
     fk_solucao_proposta AS solucao_proposta,
     fk_atendente AS atendente,
     detalhes,
     anexo
FROM chamado
WHERE id = :id";

$stmt_cabecalho = $conn->prepare($sql_cabecalho);
$stmt_cabecalho->bindParam(':id', $id_chamado, PDO::PARAM_INT);
$stmt_cabecalho->execute();
$cabecalho = $stmt_cabecalho->fetch();

// Consulta os itens do atendimento
$sql_itens = "SELECT fk_chamado AS chamado,
     DATE_FORMAT(dt_cad, '%d/%m/%Y %H:%i:%s') AS dt_hora,
     tecnico,
     prioridade,
     ocorrencia,
     atendimento,
     evento,
     tempo,
     contador_pb,
     contador_color,
     contador_total,
     scanner_total,
     anexo,
     `status`
FROM chamado_atendimento
WHERE fk_chamado = :id
ORDER BY dt_cad";

$stmt_itens = $conn->prepare($sql_itens);
$stmt_itens->bindParam(':id', $id_chamado, PDO::PARAM_INT);
$stmt_itens->execute();
$itens = $stmt_itens->fetchAll(PDO::FETCH_ASSOC);

// Criar novo documento PDF
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Informações do documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistema HelpDesk');
$pdf->SetTitle('Chamado #' . $id_chamado);
$pdf->SetSubject('Relatório de Chamado');

// Margens
$pdf->SetMargins(5, 5, 5);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);

// Quebra de página automática
$pdf->SetAutoPageBreak(TRUE, 0);

// Adicionar uma página
$pdf->AddPage();

// Logo da empresa
$logo = 'logo.png';
if (file_exists($logo)) {
    $pdf->Image($logo, 15, 10, 40, 0, '', '', 'T', false, 300, '', false, false, 0, false, false, false);
}

// Título
$pdf->SetFont('helvetica', 'B', 16);
$pdf->Cell(0, 10, 'Relatório de Chamado Nº ' . $id_chamado, 0, 1, 'C');
$pdf->Ln(10);

// Informações do cabeçalho
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 10, 'Dados do Chamado', 0, 1);
$pdf->SetFont('helvetica', '', 10);

$html = '<table border="0.5" cellpadding="4">
    <tr>
        <td width="20%"><b>Data:</b></td>
        <td width="35%">' . $cabecalho['dt'] . '</td>
        <td width="15%"><b>Cliente:</b></td>
        <td width="30%">' . $cabecalho['Cliente'] . '</td>
    </tr>
    <tr>
        <td><b>Solicitante:</b></td>
        <td>' . $cabecalho['cliente_solicitante'] . '</td>
        <td><b>Série:</b></td>
        <td>' . $cabecalho['serie'] . '</td>
    </tr>
    <tr>
        <td><b>Máquina:</b></td>
        <td>' . $cabecalho['maquina'] . '</td>
        <td><b>Setor:</b></td>
        <td>' . $cabecalho['setor'] . '</td>
    </tr>
    <tr>
        <td><b>Endereço:</b></td>
        <td>' . $cabecalho['endereco'] . '</td>
        <td><b>Cidade/UF:</b></td>
        <td>' . $cabecalho['cidade'] . '/' . $cabecalho['uf'] . '</td>
    </tr>
    <tr>
        <td><b>Tipo de Serviço:</b></td>
        <td>' . $cabecalho['tipo'] . '</td>
        <td><b>Serviço:</b></td>
        <td>' . $cabecalho['servico'] . '</td>
    </tr>
    <tr>
        <td><b>Solução Proposta:</b></td>
        <td colspan="3">' . $cabecalho['solucao_proposta'] . '</td>
    </tr>
    <tr>
        <td><b>Atendente:</b></td>
        <td>' . $cabecalho['atendente'] . '</td>
        <td><b>Detalhes:</b></td>
        <td>' . $cabecalho['detalhes'] . '</td>
    </tr>
</table>';

$pdf->writeHTML($html, true, false, true, false, '');

// Itens de atendimento
$pdf->Ln(0);
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 0, 'Histórico de Atendimentos', 0, 1);

if (count($itens) > 0) {
    $pdf->SetFont('helvetica', '', 8);
    
    $html = '<table border="0.5" cellpadding="4">
        <tr style="background-color:#f2f2f2;">
            <th width="15%">Data/Hora</th>
            <th width="15%">Técnico</th>
            <th width="10%">Prioridade</th>
            <th width="15%">Ocorrência</th>
            <th width="15%">Atendimento</th>
            <th width="10%">Evento</th>
            <th width="10%">Tempo</th>
            <th width="10%">Status</th>
        </tr>';
    
    foreach ($itens as $item) {
        $html .= '<tr>
            <td>' . $item['dt_hora'] . '</td>
            <td>' . $item['tecnico'] . '</td>
            <td>' . $item['prioridade'] . '</td>
            <td>' . $item['ocorrencia'] . '</td>
            <td>' . $item['atendimento'] . '</td>
            <td>' . $item['evento'] . '</td>
            <td>' . $item['tempo'] . '</td>
            <td>' . $item['status'] . '</td>
        </tr>';
        
        // Contadores
        if ($item['contador_pb'] || $item['contador_color'] || $item['scanner_total']) {
            $html .= '<tr style="font-size:7px;">
                <td colspan="8">
                    <b>Contadores:</b> PB: '.$item['contador_pb'].' | 
                    Color: '.$item['contador_color'].' | 
                    Total: '.$item['contador_total'].' | 
                    Scanner: '.$item['scanner_total'].'
                </td>
            </tr>';
        }
    }
    
    $html .= '</table>';
    $pdf->writeHTML($html, true, false, true, false, '');
} else {
    $pdf->Cell(0, 10, 'Nenhum item de atendimento encontrado', 0, 1);
}

// Rodapé
$pdf->SetY(-10);
$pdf->SetFont('helvetica', 'I', 8);
$pdf->Cell(0, 10, 'Gerado em ' . date('d/m/Y H:i:s'), 0, 0, 'C');

// Saída do PDF
$pdf->Output('chamado_' . $id_chamado . '.pdf', 'I');