<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type");

// Conexao com o .env
$dotenv = parse_ini_file(__DIR__ . '../../.env');
$dbHost = $dotenv['DB_HOST'];
$dbUser = $dotenv['DB_USER'];
$dbPass = $dotenv['DB_PASSWORD'];
$dbName = $dotenv['DB_NAME'];

// Conexao com o banco de dados
try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Falha na conexao com o banco de dados: ' . $e->getMessage()]);
    exit;
}

// Roteamento
$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

// Verifica se o script esta sendo acessado diretamente
if (basename($_SERVER['SCRIPT_FILENAME']) === 'fornecedor.php') {
    switch ($method) {
        case 'GET':
            if ($id) {
                getFornecedor($pdo, $id);
            } else {
                getAllFornecedors($pdo);
            }
            break;
        case 'POST':
            createFornecedor($pdo);
            break;
        case 'PUT':
            if ($id) {
                updateFornecedor($pdo, $id);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'ID do fornecedor nao especificado']);
            }
            break;
        case 'DELETE':
            if ($id) {
                deleteFornecedor($pdo, $id);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'ID do fornecedor nao especificado']);
            }
            break;
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Metodo nao permitido']);
    }
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Endpoint nao encontrado']);
}

// Funcoes CRUD

function getAllFornecedors($pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM fornecedor");
        $fornecedors = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($fornecedors);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao buscar fornecedors: ' . $e->getMessage()]);
    }
}

function getFornecedor($pdo, $id) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM fornecedor WHERE id = ?");
        $stmt->execute([$id]);
        $fornecedor = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($fornecedor) {
            echo json_encode($fornecedor);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Fornecedor nao encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao buscar fornecedor: ' . $e->getMessage()]);
    }
}

function createFornecedor($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        http_response_code(400);
        echo json_encode(['error' => 'Dados invalidos']);
        return;
    }
    
    if (!isset($data['logo'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "logo" faltando']);
        return;
    }
    if (strlen($data['logo']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "logo" deve ter no maximo 255 caracteres']);
        return;
    }

    if (!isset($data['cnpj'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cnpj" faltando']);
        return;
    }
    if (strlen($data['cnpj']) > 14) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cnpj" deve ter no maximo 14 caracteres']);
        return;
    }

    if (!isset($data['insc_est'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "insc_est" faltando']);
        return;
    }
    if (strlen($data['insc_est']) > 12) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "insc_est" deve ter no maximo 12 caracteres']);
        return;
    }

    if (!isset($data['insc_mun'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "insc_mun" faltando']);
        return;
    }
    if (strlen($data['insc_mun']) > 12) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "insc_mun" deve ter no maximo 12 caracteres']);
        return;
    }

    if (!isset($data['nome_rs'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "nome_rs" faltando']);
        return;
    }
    if (strlen($data['nome_rs']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "nome_rs" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['nome_fan'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "nome_fan" faltando']);
        return;
    }
    if (strlen($data['nome_fan']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "nome_fan" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['nome_representante'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "nome_representante" faltando']);
        return;
    }
    if (strlen($data['nome_representante']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "nome_representante" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['cpf'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cpf" faltando']);
        return;
    }
    if (strlen($data['cpf']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cpf" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['fone'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fone" faltando']);
        return;
    }
    if (strlen($data['fone']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "fone" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['fax'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fax" faltando']);
        return;
    }
    if (strlen($data['fax']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "fax" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['cel'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cel" faltando']);
        return;
    }
    if (strlen($data['cel']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cel" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['email'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "email" faltando']);
        return;
    }
    if (strlen($data['email']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "email" deve ter no maximo 255 caracteres']);
        return;
    }

    if (!isset($data['site'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "site" faltando']);
        return;
    }
    if (strlen($data['site']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "site" deve ter no maximo 255 caracteres']);
        return;
    }

    if (!isset($data['endereco'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "endereco" faltando']);
        return;
    }
    if (strlen($data['endereco']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "endereco" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['numero'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "numero" faltando']);
        return;
    }
    if (strlen($data['numero']) > 10) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "numero" deve ter no maximo 10 caracteres']);
        return;
    }

    if (!isset($data['complemento'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "complemento" faltando']);
        return;
    }
    if (strlen($data['complemento']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "complemento" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['bairro'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "bairro" faltando']);
        return;
    }
    if (strlen($data['bairro']) > 30) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "bairro" deve ter no maximo 30 caracteres']);
        return;
    }

    if (!isset($data['cidade'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cidade" faltando']);
        return;
    }
    if (strlen($data['cidade']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cidade" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['cep'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cep" faltando']);
        return;
    }
    if (strlen($data['cep']) > 10) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cep" deve ter no maximo 10 caracteres']);
        return;
    }

    if (!isset($data['localizacao'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "localizacao" faltando']);
        return;
    }


    try {
        $sql = "INSERT INTO fornecedor (`logo`, `cnpj`, `insc_est`, `insc_mun`, `nome_rs`, `nome_fan`, `nome_representante`, `cpf`, `fone`, `fax`, `cel`, `email`, `site`, `endereco`, `numero`, `complemento`, `bairro`, `cidade`, `cep`, `localizacao`) VALUES (:logo, :cnpj, :insc_est, :insc_mun, :nome_rs, :nome_fan, :nome_representante, :cpf, :fone, :fax, :cel, :email, :site, :endereco, :numero, :complemento, :bairro, :cidade, :cep, :localizacao)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':logo' => $data['logo'], ':cnpj' => $data['cnpj'], ':insc_est' => $data['insc_est'], ':insc_mun' => $data['insc_mun'], ':nome_rs' => $data['nome_rs'], ':nome_fan' => $data['nome_fan'], ':nome_representante' => $data['nome_representante'], ':cpf' => $data['cpf'], ':fone' => $data['fone'], ':fax' => $data['fax'], ':cel' => $data['cel'], ':email' => $data['email'], ':site' => $data['site'], ':endereco' => $data['endereco'], ':numero' => $data['numero'], ':complemento' => $data['complemento'], ':bairro' => $data['bairro'], ':cidade' => $data['cidade'], ':cep' => $data['cep'], ':localizacao' => $data['localizacao']
        ]);
        
        $id = $pdo->lastInsertId();
        http_response_code(201);
        echo json_encode(['id' => $id, 'message' => 'Fornecedor criado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao criar fornecedor: ' . $e->getMessage()]);
    }
}

function updateFornecedor($pdo, $id) {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        http_response_code(400);
        echo json_encode(['error' => 'Dados invalidos']);
        return;
    }
    
    if (!isset($data['logo'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "logo" faltando']);
        return;
    }
    if (strlen($data['logo']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "logo" deve ter no maximo 255 caracteres']);
        return;
    }

    if (!isset($data['cnpj'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cnpj" faltando']);
        return;
    }
    if (strlen($data['cnpj']) > 14) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cnpj" deve ter no maximo 14 caracteres']);
        return;
    }

    if (!isset($data['insc_est'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "insc_est" faltando']);
        return;
    }
    if (strlen($data['insc_est']) > 12) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "insc_est" deve ter no maximo 12 caracteres']);
        return;
    }

    if (!isset($data['insc_mun'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "insc_mun" faltando']);
        return;
    }
    if (strlen($data['insc_mun']) > 12) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "insc_mun" deve ter no maximo 12 caracteres']);
        return;
    }

    if (!isset($data['nome_rs'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "nome_rs" faltando']);
        return;
    }
    if (strlen($data['nome_rs']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "nome_rs" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['nome_fan'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "nome_fan" faltando']);
        return;
    }
    if (strlen($data['nome_fan']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "nome_fan" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['nome_representante'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "nome_representante" faltando']);
        return;
    }
    if (strlen($data['nome_representante']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "nome_representante" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['cpf'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cpf" faltando']);
        return;
    }
    if (strlen($data['cpf']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cpf" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['fone'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fone" faltando']);
        return;
    }
    if (strlen($data['fone']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "fone" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['fax'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "fax" faltando']);
        return;
    }
    if (strlen($data['fax']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "fax" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['cel'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cel" faltando']);
        return;
    }
    if (strlen($data['cel']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cel" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['email'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "email" faltando']);
        return;
    }
    if (strlen($data['email']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "email" deve ter no maximo 255 caracteres']);
        return;
    }

    if (!isset($data['site'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "site" faltando']);
        return;
    }
    if (strlen($data['site']) > 255) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "site" deve ter no maximo 255 caracteres']);
        return;
    }

    if (!isset($data['endereco'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "endereco" faltando']);
        return;
    }
    if (strlen($data['endereco']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "endereco" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['numero'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "numero" faltando']);
        return;
    }
    if (strlen($data['numero']) > 10) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "numero" deve ter no maximo 10 caracteres']);
        return;
    }

    if (!isset($data['complemento'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "complemento" faltando']);
        return;
    }
    if (strlen($data['complemento']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "complemento" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['bairro'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "bairro" faltando']);
        return;
    }
    if (strlen($data['bairro']) > 30) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "bairro" deve ter no maximo 30 caracteres']);
        return;
    }

    if (!isset($data['cidade'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cidade" faltando']);
        return;
    }
    if (strlen($data['cidade']) > 50) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cidade" deve ter no maximo 50 caracteres']);
        return;
    }

    if (!isset($data['cep'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cep" faltando']);
        return;
    }
    if (strlen($data['cep']) > 10) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "cep" deve ter no maximo 10 caracteres']);
        return;
    }

    if (!isset($data['localizacao'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "localizacao" faltando']);
        return;
    }


    try {
        // Verifica se o fornecedor existe
        $check = $pdo->prepare("SELECT id FROM fornecedor WHERE id = ?");
        $check->execute([$id]);
        
        if (!$check->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Fornecedor nao encontrado']);
            return;
        }
        
        $sql = "UPDATE fornecedor SET `logo` = :logo, `cnpj` = :cnpj, `insc_est` = :insc_est, `insc_mun` = :insc_mun, `nome_rs` = :nome_rs, `nome_fan` = :nome_fan, `nome_representante` = :nome_representante, `cpf` = :cpf, `fone` = :fone, `fax` = :fax, `cel` = :cel, `email` = :email, `site` = :site, `endereco` = :endereco, `numero` = :numero, `complemento` = :complemento, `bairro` = :bairro, `cidade` = :cidade, `cep` = :cep, `localizacao` = :localizacao WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':logo' => $data['logo'], ':cnpj' => $data['cnpj'], ':insc_est' => $data['insc_est'], ':insc_mun' => $data['insc_mun'], ':nome_rs' => $data['nome_rs'], ':nome_fan' => $data['nome_fan'], ':nome_representante' => $data['nome_representante'], ':cpf' => $data['cpf'], ':fone' => $data['fone'], ':fax' => $data['fax'], ':cel' => $data['cel'], ':email' => $data['email'], ':site' => $data['site'], ':endereco' => $data['endereco'], ':numero' => $data['numero'], ':complemento' => $data['complemento'], ':bairro' => $data['bairro'], ':cidade' => $data['cidade'], ':cep' => $data['cep'], ':localizacao' => $data['localizacao'], ':id' => $id
        ]);
        
        echo json_encode(['message' => 'Fornecedor atualizado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao atualizar fornecedor: ' . $e->getMessage()]);
    }
}

function deleteFornecedor($pdo, $id) {
    try {
        // Verifica se o fornecedor existe
        $check = $pdo->prepare("SELECT id FROM fornecedor WHERE id = ?");
        $check->execute([$id]);
        
        if (!$check->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Fornecedor nao encontrado']);
            return;
        }
        
        $stmt = $pdo->prepare("DELETE FROM fornecedor WHERE id = ?");
        $stmt->execute([$id]);
        
        echo json_encode(['message' => 'Fornecedor deletado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao deletar fornecedor: ' . $e->getMessage()]);
    }
}
?>