<?php
$api_url = 'http://localhost/jps-service/backend/routers/contrato.php';
$data = json_decode(file_get_contents($api_url), true);

// Função para formatar valores se necessário
function formatValue($value) {
    if (is_numeric($value)) {
        return number_format(floatval($value), 2, ',', '.');
    }
    return $value;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestão de Contrato</title>
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    .btn-action {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
    }

    .modal-lg-custom {
        max-width: 800px;
    }
    </style>
</head>

<body>
    <div class="container-fluid mt-4">
        <h1 class="mb-4">Gestão de Contrato</h1>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Lista de Contrato</h5>
                <div>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#cadastrarModal">
                        <i class="fas fa-plus me-1"></i> Novo Registro
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="dataTable" class="table table-striped table-bordered nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Dt Ini Contrato</th>
                            <th>Dt Fim Contrato</th>
                            <th>Prazo</th>
                            <th>Pb Franquia</th>
                            <th>Pb Excedente</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $item): ?>
                        <tr>
                            <td><?= formatValue($item["id"]) ?></td>
                            <td><?= formatValue($item["dt_ini_contrato"]) ?></td>
                            <td><?= formatValue($item["dt_fim_contrato"]) ?></td>
                            <td><?= formatValue($item["prazo"]) ?></td>
                            <td><?= formatValue($item["pb_franquia"]) ?></td>
                            <td><?= formatValue($item["pb_excedente"]) ?></td>
                            <td><?= formatValue($item["status"]) ?></td>
                            <td>
                                <button class="btn btn-info btn-action btn-view" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-warning btn-action btn-edit" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-action btn-delete" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Visualizar -->
    <div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Detalhes</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="viewModalBody">
                    <!-- Conteúdo será preenchido via AJAX -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Editar -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Editar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editForm" method="POST">
                    <div class="modal-body" id="editModalBody">
                        <!-- Conteúdo será preenchido via AJAX -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Excluir -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Você tem certeza que deseja excluir este registro? Esta ação não pode ser desfeita.</p>
                    <input type="hidden" id="deleteId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">Excluir</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cadastrar -->
    <div class="modal fade" id="cadastrarModal" tabindex="-1" aria-labelledby="cadastrarModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cadastrarModalLabel">Cadastrar Novo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="cadastrarForm" method="POST">
                    <div class="modal-body">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label for="fk_cliente" class="form-label">Fk Cliente</label>
                                <input type="text" class="form-control" id="fk_cliente" name="fk_cliente" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_vendedor" class="form-label">Fk Vendedor</label>
                                <input type="text" class="form-control" id="fk_vendedor" name="fk_vendedor" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_faturista" class="form-label">Fk Faturista</label>
                                <input type="text" class="form-control" id="fk_faturista" name="fk_faturista" required>
                            </div>

                            <div class="col-md-6">
                                <label for="fk_tp_contrato" class="form-label">Fk Tp Contrato</label>
                                <input type="text" class="form-control" id="fk_tp_contrato" name="fk_tp_contrato"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="dt_ini_contrato" class="form-label">Dt Ini Contrato</label>
                                <input type="text" class="form-control" id="dt_ini_contrato" name="dt_ini_contrato"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="dt_fim_contrato" class="form-label">Dt Fim Contrato</label>
                                <input type="text" class="form-control" id="dt_fim_contrato" name="dt_fim_contrato"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="dt_vencimento" class="form-label">Dt Vencimento</label>
                                <input type="text" class="form-control" id="dt_vencimento" name="dt_vencimento"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="prazo" class="form-label">Prazo</label>
                                <input type="text" class="form-control" id="prazo" name="prazo" required>
                            </div>

                            <div class="col-md-6">
                                <label for="pb_franquia" class="form-label">Pb Franquia</label>
                                <input type="text" class="form-control" id="pb_franquia" name="pb_franquia" required>
                            </div>

                            <div class="col-md-6">
                                <label for="pb_excedente" class="form-label">Pb Excedente</label>
                                <input type="text" class="form-control" id="pb_excedente" name="pb_excedente" required>
                            </div>

                            <div class="col-md-6">
                                <label for="color_laser_franquia" class="form-label">Color Laser Franquia</label>
                                <input type="text" class="form-control" id="color_laser_franquia"
                                    name="color_laser_franquia" required>
                            </div>

                            <div class="col-md-6">
                                <label for="color_laser_excedente" class="form-label">Color Laser Excedente</label>
                                <input type="text" class="form-control" id="color_laser_excedente"
                                    name="color_laser_excedente" required>
                            </div>

                            <div class="col-md-6">
                                <label for="color_jato_franquia" class="form-label">Color Jato Franquia</label>
                                <input type="text" class="form-control" id="color_jato_franquia"
                                    name="color_jato_franquia" required>
                            </div>

                            <div class="col-md-6">
                                <label for="color_jato_excedente" class="form-label">Color Jato Excedente</label>
                                <input type="text" class="form-control" id="color_jato_excedente"
                                    name="color_jato_excedente" required>
                            </div>

                            <div class="col-md-6">
                                <label for="digit_franquia" class="form-label">Digit Franquia</label>
                                <input type="text" class="form-control" id="digit_franquia" name="digit_franquia"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="digit_excedente" class="form-label">Digit Excedente</label>
                                <input type="text" class="form-control" id="digit_excedente" name="digit_excedente"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="outros_especificar" class="form-label">Outros Especificar</label>
                                <input type="text" class="form-control" id="outros_especificar"
                                    name="outros_especificar" required>
                            </div>

                            <div class="col-md-6">
                                <label for="outros_franquia" class="form-label">Outros Franquia</label>
                                <input type="text" class="form-control" id="outros_franquia" name="outros_franquia"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="outros_excedente" class="form-label">Outros Excedente</label>
                                <input type="text" class="form-control" id="outros_excedente" name="outros_excedente"
                                    required>
                            </div>

                            <div class="col-md-6">
                                <label for="anexo" class="form-label">Anexo</label>
                                <input type="text" class="form-control" id="anexo" name="anexo" required>
                            </div>

                            <div class="col-md-6">
                                <label for="obs" class="form-label">Obs</label>
                                <input type="text" class="form-control" id="obs" name="obs" required>
                            </div>

                            <div class="col-md-6">
                                <label for="status" class="form-label">Status</label>
                                <input type="text" class="form-control" id="status" name="status" required>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- jQuery, Bootstrap e DataTables JS -->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.js"></script>
    <!-- Excel export -->
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

    <script>
    $(document).ready(function() {
        // Inicialização do DataTable com botão de exportação
        var table = $('#dataTable').DataTable({
            responsive: true,
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excel',
                text: '<i class="fas fa-file-excel me-1"></i> Exportar Excel',
                className: 'btn btn-success btn-sm',
                title: 'Contrato',
                exportOptions: {
                    columns: ':not(:last-child)' // Exclui a coluna de ações
                }
            }],
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json'
            }
        });

        // Visualizar registro
        $(document).on('click', '.btn-view', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<div class="row">';
                    html += `
                            <div class="col-md-6">
                                <p><strong>Id:</strong> ${item['id'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Cliente:</strong> ${item['fk_cliente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Vendedor:</strong> ${item['fk_vendedor'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Faturista:</strong> ${item['fk_faturista'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Fk Tp Contrato:</strong> ${item['fk_tp_contrato'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Dt Ini Contrato:</strong> ${item['dt_ini_contrato'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Dt Fim Contrato:</strong> ${item['dt_fim_contrato'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Dt Vencimento:</strong> ${item['dt_vencimento'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Prazo:</strong> ${item['prazo'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Pb Franquia:</strong> ${item['pb_franquia'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Pb Excedente:</strong> ${item['pb_excedente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Color Laser Franquia:</strong> ${item['color_laser_franquia'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Color Laser Excedente:</strong> ${item['color_laser_excedente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Color Jato Franquia:</strong> ${item['color_jato_franquia'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Color Jato Excedente:</strong> ${item['color_jato_excedente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Digit Franquia:</strong> ${item['digit_franquia'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Digit Excedente:</strong> ${item['digit_excedente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Outros Especificar:</strong> ${item['outros_especificar'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Outros Franquia:</strong> ${item['outros_franquia'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Outros Excedente:</strong> ${item['outros_excedente'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Anexo:</strong> ${item['anexo'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Obs:</strong> ${item['obs'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Status:</strong> ${item['status'] || 'N/A'}</p>
                            </div>
                        `;
                    html += '</div>';
                    $('#viewModalBody').html(html);
                    $('#viewModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro: ' + error);
                }
            });
        });

        // Editar registro - Abrir modal
        $(document).on('click', '.btn-edit', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<input type="hidden" name="id" value="' + item.id + '">';
                    html += '<div class="row g-3">';
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_cliente" class="form-label">Fk Cliente</label>
                                <input type="text" class="form-control" id="edit_fk_cliente" name="fk_cliente" value="${item['fk_cliente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_vendedor" class="form-label">Fk Vendedor</label>
                                <input type="text" class="form-control" id="edit_fk_vendedor" name="fk_vendedor" value="${item['fk_vendedor'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_faturista" class="form-label">Fk Faturista</label>
                                <input type="text" class="form-control" id="edit_fk_faturista" name="fk_faturista" value="${item['fk_faturista'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_fk_tp_contrato" class="form-label">Fk Tp Contrato</label>
                                <input type="text" class="form-control" id="edit_fk_tp_contrato" name="fk_tp_contrato" value="${item['fk_tp_contrato'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_dt_ini_contrato" class="form-label">Dt Ini Contrato</label>
                                <input type="text" class="form-control" id="edit_dt_ini_contrato" name="dt_ini_contrato" value="${item['dt_ini_contrato'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_dt_fim_contrato" class="form-label">Dt Fim Contrato</label>
                                <input type="text" class="form-control" id="edit_dt_fim_contrato" name="dt_fim_contrato" value="${item['dt_fim_contrato'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_dt_vencimento" class="form-label">Dt Vencimento</label>
                                <input type="text" class="form-control" id="edit_dt_vencimento" name="dt_vencimento" value="${item['dt_vencimento'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_prazo" class="form-label">Prazo</label>
                                <input type="text" class="form-control" id="edit_prazo" name="prazo" value="${item['prazo'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_pb_franquia" class="form-label">Pb Franquia</label>
                                <input type="text" class="form-control" id="edit_pb_franquia" name="pb_franquia" value="${item['pb_franquia'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_pb_excedente" class="form-label">Pb Excedente</label>
                                <input type="text" class="form-control" id="edit_pb_excedente" name="pb_excedente" value="${item['pb_excedente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_color_laser_franquia" class="form-label">Color Laser Franquia</label>
                                <input type="text" class="form-control" id="edit_color_laser_franquia" name="color_laser_franquia" value="${item['color_laser_franquia'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_color_laser_excedente" class="form-label">Color Laser Excedente</label>
                                <input type="text" class="form-control" id="edit_color_laser_excedente" name="color_laser_excedente" value="${item['color_laser_excedente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_color_jato_franquia" class="form-label">Color Jato Franquia</label>
                                <input type="text" class="form-control" id="edit_color_jato_franquia" name="color_jato_franquia" value="${item['color_jato_franquia'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_color_jato_excedente" class="form-label">Color Jato Excedente</label>
                                <input type="text" class="form-control" id="edit_color_jato_excedente" name="color_jato_excedente" value="${item['color_jato_excedente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_digit_franquia" class="form-label">Digit Franquia</label>
                                <input type="text" class="form-control" id="edit_digit_franquia" name="digit_franquia" value="${item['digit_franquia'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_digit_excedente" class="form-label">Digit Excedente</label>
                                <input type="text" class="form-control" id="edit_digit_excedente" name="digit_excedente" value="${item['digit_excedente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_outros_especificar" class="form-label">Outros Especificar</label>
                                <input type="text" class="form-control" id="edit_outros_especificar" name="outros_especificar" value="${item['outros_especificar'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_outros_franquia" class="form-label">Outros Franquia</label>
                                <input type="text" class="form-control" id="edit_outros_franquia" name="outros_franquia" value="${item['outros_franquia'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_outros_excedente" class="form-label">Outros Excedente</label>
                                <input type="text" class="form-control" id="edit_outros_excedente" name="outros_excedente" value="${item['outros_excedente'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_anexo" class="form-label">Anexo</label>
                                <input type="text" class="form-control" id="edit_anexo" name="anexo" value="${item['anexo'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_obs" class="form-label">Obs</label>
                                <input type="text" class="form-control" id="edit_obs" name="obs" value="${item['obs'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_status" class="form-label">Status</label>
                                <input type="text" class="form-control" id="edit_status" name="status" value="${item['status'] || ''}" required>
                            </div>
                        `;
                    html += '</div>';
                    $('#editModalBody').html(html);
                    $('#editModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro para edição: ' + error);
                }
            });
        });

        // Submit do formulário de edição
        $('#editForm').submit(function(e) {
            e.preventDefault();
            var id = $('input[name="id"]').val();
            var formData = {
                "fk_cliente": $("#edit_fk_cliente").val(),
                "fk_vendedor": $("#edit_fk_vendedor").val(),
                "fk_faturista": $("#edit_fk_faturista").val(),
                "fk_tp_contrato": $("#edit_fk_tp_contrato").val(),
                "dt_ini_contrato": $("#edit_dt_ini_contrato").val(),
                "dt_fim_contrato": $("#edit_dt_fim_contrato").val(),
                "dt_vencimento": $("#edit_dt_vencimento").val(),
                "prazo": $("#edit_prazo").val(),
                "pb_franquia": $("#edit_pb_franquia").val(),
                "pb_excedente": $("#edit_pb_excedente").val(),
                "color_laser_franquia": $("#edit_color_laser_franquia").val(),
                "color_laser_excedente": $("#edit_color_laser_excedente").val(),
                "color_jato_franquia": $("#edit_color_jato_franquia").val(),
                "color_jato_excedente": $("#edit_color_jato_excedente").val(),
                "digit_franquia": $("#edit_digit_franquia").val(),
                "digit_excedente": $("#edit_digit_excedente").val(),
                "outros_especificar": $("#edit_outros_especificar").val(),
                "outros_franquia": $("#edit_outros_franquia").val(),
                "outros_excedente": $("#edit_outros_excedente").val(),
                "anexo": $("#edit_anexo").val(),
                "obs": $("#edit_obs").val(),
                "status": $("#edit_status").val()
            };

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'PUT',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro atualizado com sucesso!');
                    $('#editModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao atualizar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Excluir registro
        $(document).on('click', '.btn-delete', function() {
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteModal').modal('show');
        });

        // Confirmar exclusão
        $('#confirmDelete').click(function() {
            var id = $('#deleteId').val();

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'DELETE',
                success: function(response) {
                    alert('Registro excluído com sucesso!');
                    $('#deleteModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao excluir o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Submit do formulário de cadastro
        $('#cadastrarForm').submit(function(e) {
            e.preventDefault();
            var formData = {
                "fk_cliente": $("#fk_cliente").val(),
                "fk_vendedor": $("#fk_vendedor").val(),
                "fk_faturista": $("#fk_faturista").val(),
                "fk_tp_contrato": $("#fk_tp_contrato").val(),
                "dt_ini_contrato": $("#dt_ini_contrato").val(),
                "dt_fim_contrato": $("#dt_fim_contrato").val(),
                "dt_vencimento": $("#dt_vencimento").val(),
                "prazo": $("#prazo").val(),
                "pb_franquia": $("#pb_franquia").val(),
                "pb_excedente": $("#pb_excedente").val(),
                "color_laser_franquia": $("#color_laser_franquia").val(),
                "color_laser_excedente": $("#color_laser_excedente").val(),
                "color_jato_franquia": $("#color_jato_franquia").val(),
                "color_jato_excedente": $("#color_jato_excedente").val(),
                "digit_franquia": $("#digit_franquia").val(),
                "digit_excedente": $("#digit_excedente").val(),
                "outros_especificar": $("#outros_especificar").val(),
                "outros_franquia": $("#outros_franquia").val(),
                "outros_excedente": $("#outros_excedente").val(),
                "anexo": $("#anexo").val(),
                "obs": $("#obs").val(),
                "status": $("#status").val()
            };

            $.ajax({
                url: '<?= $api_url ?>',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro cadastrado com sucesso!');
                    $('#cadastrarModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao cadastrar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });
    });
    </script>
</body>

</html>