<?php
$api_url = 'http://localhost/jps-service/backend/routers/usuarios.php';
$data = json_decode(file_get_contents($api_url), true);

// Função para formatar valores se necessário
function formatValue($value, $type = 'default') {
    switch ($type) {
        case 'password':
            return '••••••'; // Ou str_repeat('•', strlen($value)) para mostrar um caractere por cada caractere da senha
        case 'upload':
            return basename($value); // Mostra apenas o nome do arquivo
        case 'geometric':
            return is_numeric($value) ? number_format(floatval($value), 0, ',', '.') : $value; // Sem casas decimais
        case 'decimal':
            return is_numeric($value) ? number_format(floatval($value), 2, ',', '.') : $value; // Com 2 casas decimais
        default:
            return $value; // Sem formatação especial
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestão de Usuarios</title>
    <link rel="stylesheet" type="text/css"
        href="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    .btn-action {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
    }

    .modal-lg-custom {
        max-width: 800px;
    }
    </style>
</head>

<body>
    <div class="container-fluid mt-4">
        <h1 class="mb-4">Gestão de Usuarios</h1>

        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Lista de Usuarios</h5>
                <div>
                    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#cadastrarModal">
                        <i class="fas fa-plus me-1"></i> Novo Registro
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="dataTable" class="table table-striped table-bordered nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Foto</th>
                            <th>Login</th>
                            <th>Senha</th>
                            <th>Nome</th>
                            <th>Cpf</th>
                            <th>Cel</th>
                            <th>Email</th>
                            <th>Perfil</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $item): ?>
                        <tr>
                            <td><?= formatValue($item["id"]) ?></td>
                            <td><?= formatValue($item["foto"]) ?></td>
                            <td><?= formatValue($item["login"]) ?></td>
                            <td><?= formatValue($item["senha"], 'password') ?></td>
                            <td><?= formatValue($item["nome"]) ?></td>
                            <td><?= formatValue($item["cpf"]) ?></td>
                            <td><?= formatValue($item["cel"]) ?></td>
                            <td><?= formatValue($item["email"]) ?></td>
                            <td><?= formatValue($item["perfil"]) ?></td>
                            <td><?= formatValue($item["status"]) ?></td>
                            <td>
                                <button class="btn btn-info btn-action btn-view" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="btn btn-warning btn-action btn-edit" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-danger btn-action btn-delete" data-id="<?= $item["id"] ?>">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal Visualizar -->
    <div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewModalLabel">Detalhes</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="viewModalBody">
                    <!-- Conteúdo será preenchido via AJAX -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Editar -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Editar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editForm" method="POST">
                    <div class="modal-body" id="editModalBody">
                        <!-- Conteúdo será preenchido via AJAX -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Excluir -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirmar Exclusão</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Você tem certeza que deseja excluir este registro? Esta ação não pode ser desfeita.</p>
                    <input type="hidden" id="deleteId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="button" class="btn btn-danger" id="confirmDelete">Excluir</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cadastrar -->
    <div class="modal fade" id="cadastrarModal" tabindex="-1" aria-labelledby="cadastrarModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-lg-custom">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cadastrarModalLabel">Cadastrar Novo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="cadastrarForm" method="POST">
                    <div class="modal-body">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label for="foto" class="form-label">Foto</label>
                                <input type="file" class="form-control" id="foto" name="foto" accept="image/*" required>
                                <small class="form-text text-muted">Selecione uma imagem (JPG, PNG, etc.).</small>
                            </div>

                            <div class="col-md-6">
                                <label for="login" class="form-label">Login</label>
                                <input type="text" class="form-control" id="login" name="login" required>
                            </div>

                            <div class="col-md-6">
                                <label for="senha" class="form-label">Senha</label>
                                <input type="password" class="form-control" id="senha" name="senha" required>
                            </div>

                            <div class="col-md-6">
                                <label for="nome" class="form-label">Nome</label>
                                <input type="text" class="form-control" id="nome" name="nome" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cpf" class="form-label">Cpf</label>
                                <input type="text" class="form-control" id="cpf" name="cpf" required>
                            </div>

                            <div class="col-md-6">
                                <label for="cel" class="form-label">Cel</label>
                                <input type="text" class="form-control" id="cel" name="cel" required>
                            </div>

                            <div class="col-md-6">
                                <label for="email" class="form-label">Email</label>
                                <input type="text" class="form-control" id="email" name="email" required>
                            </div>

                            <div class="col-md-6">
                                <label for="perfil" class="form-label">Perfil</label>
                               <select class="form-control" id="perfil" name="perfil" required>
                                    <option value="">Selecione...</option>
                                    <option value="Administrador">Administrador</option>
                                    <option value="Suporte">Suporte</option>
                                    <option value="Cliente">Cliente</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="">Selecione...</option>
                                    <option value="Ativo">Ativo</option>
                                    <option value="Bloqueado">Bloqueado</option>
                                </select>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Cadastrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- jQuery, Bootstrap e DataTables JS -->
    <script type="text/javascript" src="https://cdn.datatables.net/v/bs5/jq-3.6.0/dt-1.11.5/datatables.min.js"></script>
    <!-- Excel export -->
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

    <script>
    $(document).ready(function() {
        // Inicialização do DataTable com botão de exportação
        var table = $('#dataTable').DataTable({
            responsive: true,
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excel',
                text: '<i class="fas fa-file-excel me-1"></i> Exportar Excel',
                className: 'btn btn-success btn-sm',
                title: 'Usuarios',
                exportOptions: {
                    columns: ':not(:last-child)' // Exclui a coluna de ações
                }
            }],
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json'
            }
        });

        // Visualizar registro
        $(document).on('click', '.btn-view', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<div class="row">';
                    html += `
                            <div class="col-md-6">
                                <p><strong>Id:</strong> ${item['id'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Foto:</strong> ${item['foto'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Login:</strong> ${item['login'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Senha:</strong> ${item['senha'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Nome:</strong> ${item['nome'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cpf:</strong> ${item['cpf'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Cel:</strong> ${item['cel'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Email:</strong> ${item['email'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Perfil:</strong> ${item['perfil'] || 'N/A'}</p>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <p><strong>Status:</strong> ${item['status'] || 'N/A'}</p>
                            </div>
                        `;
                    html += '</div>';
                    $('#viewModalBody').html(html);
                    $('#viewModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro: ' + error);
                }
            });
        });

        // Editar registro - Abrir modal
        $(document).on('click', '.btn-edit', function() {
            var id = $(this).data('id');
            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'GET',
                dataType: 'json',
                success: function(item) {
                    var html = '<input type="hidden" name="id" value="' + item.id + '">';
                    html += '<div class="row g-3">';
                    html += `
                            <div class="col-md-6">
                                <label for="edit_foto" class="form-label">Foto</label>
                                <input type="text" class="form-control" id="edit_foto" name="foto" value="${item['foto'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_login" class="form-label">Login</label>
                                <input type="text" class="form-control" id="edit_login" name="login" value="${item['login'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_senha" class="form-label">Senha</label>
                                <input type="password" class="form-control" id="edit_senha" name="senha" value="${item['senha'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_nome" class="form-label">Nome</label>
                                <input type="text" class="form-control" id="edit_nome" name="nome" value="${item['nome'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cpf" class="form-label">Cpf</label>
                                <input type="text" class="form-control" id="edit_cpf" name="cpf" value="${item['cpf'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_cel" class="form-label">Cel</label>
                                <input type="text" class="form-control" id="edit_cel" name="cel" value="${item['cel'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_email" class="form-label">Email</label>
                                <input type="text" class="form-control" id="edit_email" name="email" value="${item['email'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_perfil" class="form-label">Perfil</label>
                                <input type="text" class="form-control" id="edit_perfil" name="perfil" value="${item['perfil'] || ''}" required>
                            </div>
                        `;
                    html += `
                            <div class="col-md-6">
                                <label for="edit_status" class="form-label">Status</label>
                                <input type="text" class="form-control" id="edit_status" name="status" value="${item['status'] || ''}" required>
                            </div>
                        `;
                    html += '</div>';
                    $('#editModalBody').html(html);
                    $('#editModal').modal('show');
                },
                error: function(xhr, status, error) {
                    alert('Erro ao carregar registro para edição: ' + error);
                }
            });
        });

        // Submit do formulário de edição
        $('#editForm').submit(function(e) {
            e.preventDefault();
            var id = $('input[name="id"]').val();
            var formData = {
                "foto": $("#edit_foto").val(),
                "login": $("#edit_login").val(),
                "senha": $("#edit_senha").val(),
                "nome": $("#edit_nome").val(),
                "cpf": $("#edit_cpf").val(),
                "cel": $("#edit_cel").val(),
                "email": $("#edit_email").val(),
                "perfil": $("#edit_perfil").val(),
                "status": $("#edit_status").val()
            };

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'PUT',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro atualizado com sucesso!');
                    $('#editModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao atualizar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Excluir registro
        $(document).on('click', '.btn-delete', function() {
            var id = $(this).data('id');
            $('#deleteId').val(id);
            $('#deleteModal').modal('show');
        });

        // Confirmar exclusão
        $('#confirmDelete').click(function() {
            var id = $('#deleteId').val();

            $.ajax({
                url: '<?= $api_url ?>?id=' + id,
                type: 'DELETE',
                success: function(response) {
                    alert('Registro excluído com sucesso!');
                    $('#deleteModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao excluir o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });

        // Submit do formulário de cadastro
        $('#cadastrarForm').submit(function(e) {
            e.preventDefault();
            var formData = {
                "foto": $("#foto").val(),
                "login": $("#login").val(),
                "senha": $("#senha").val(),
                "nome": $("#nome").val(),
                "cpf": $("#cpf").val(),
                "cel": $("#cel").val(),
                "email": $("#email").val(),
                "perfil": $("#perfil").val(),
                "status": $("#status").val()
            };

            $.ajax({
                url: '<?= $api_url ?>',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    alert('Registro cadastrado com sucesso!');
                    $('#cadastrarModal').modal('hide');
                    location.reload();
                },
                error: function(xhr, status, error) {
                    alert('Erro ao cadastrar o registro: ' + (xhr.responseJSON?.error ||
                        error));
                }
            });
        });
    });
    </script>
</body>

</html>