<?php
session_start();

// if (!isset($_SESSION['codusr'])) {
//     die(json_encode(['success' => false, 'message' => 'Usuário não autenticado']));
// }

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die(json_encode(['success' => false, 'message' => 'Método não permitido']));
}

if (!isset($_POST['garantia_data'])) {
    die(json_encode(['success' => false, 'message' => 'Dados da garantia não recebidos']));
}

$garantiaData = json_decode($_POST['garantia_data'], true);
if (json_last_error() !== JSON_ERROR_NONE) {
    die(json_encode(['success' => false, 'message' => 'Dados da garantia inválidos']));
}

// Define o diretório para salvar os JSONs
$jsonDir = 'json/';
if (!file_exists($jsonDir)) {
    mkdir($jsonDir, 0777, true);
}

// Gera um nome de arquivo único
$filename = $jsonDir . 'garantia_' . $garantiaData['garantia']['id'] . '.json';

// Salva o JSON no arquivo
if (file_put_contents($filename, json_encode($garantiaData, JSON_PRETTY_PRINT))) {
    $response = ['success' => true];
    
    if ($_POST['action'] === 'finalizar') {
        // Aqui você pode adicionar lógica adicional para finalizar a garantia
        $response['message'] = 'Garantia finalizada com sucesso';
    } else {
        $response['message'] = 'Garantia gravada em digitação';
    }
    
    echo json_encode($response);
} else {
    echo json_encode(['success' => false, 'message' => 'Erro ao salvar o arquivo JSON']);
}
?>