<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type");

// Conexao com o .env
$dotenv = parse_ini_file(__DIR__ . '../../.env');
$dbHost = $dotenv['DB_HOST'];
$dbUser = $dotenv['DB_USER'];
$dbPass = $dotenv['DB_PASSWORD'];
$dbName = $dotenv['DB_NAME'];

// Conexao com o banco de dados
try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Falha na conexao com o banco de dados: ' . $e->getMessage()]);
    exit;
}

// Roteamento
$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

// Verifica se o script esta sendo acessado diretamente
if (basename($_SERVER['SCRIPT_FILENAME']) === 'produto_ncm.php') {
    switch ($method) {
        case 'GET':
            if ($id) {
                getProduto_ncm($pdo, $id);
            } else {
                getAllProduto_ncms($pdo);
            }
            break;
        case 'POST':
            createProduto_ncm($pdo);
            break;
        case 'PUT':
            if ($id) {
                updateProduto_ncm($pdo, $id);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'ID do produto_ncm nao especificado']);
            }
            break;
        case 'DELETE':
            if ($id) {
                deleteProduto_ncm($pdo, $id);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'ID do produto_ncm nao especificado']);
            }
            break;
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Metodo nao permitido']);
    }
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Endpoint nao encontrado']);
}

// Funcoes CRUD

function getAllProduto_ncms($pdo) {
    try {
        $stmt = $pdo->query("SELECT * FROM produto_ncm");
        $produto_ncms = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo json_encode($produto_ncms);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao buscar produto_ncms: ' . $e->getMessage()]);
    }
}

function getProduto_ncm($pdo, $id) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM produto_ncm WHERE id = ?");
        $stmt->execute([$id]);
        $produto_ncm = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($produto_ncm) {
            echo json_encode($produto_ncm);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Produto_ncm nao encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao buscar produto_ncm: ' . $e->getMessage()]);
    }
}

function createProduto_ncm($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        http_response_code(400);
        echo json_encode(['error' => 'Dados invalidos']);
        return;
    }
    
    if (!isset($data['cod'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cod" faltando']);
        return;
    }

    if (!isset($data['descricao'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "descricao" faltando']);
        return;
    }
    if (strlen($data['descricao']) > 225) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "descricao" deve ter no maximo 225 caracteres']);
        return;
    }


    try {
        $sql = "INSERT INTO produto_ncm (`cod`, `descricao`) VALUES (:cod, :descricao)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':cod' => $data['cod'], ':descricao' => $data['descricao']
        ]);
        
        $id = $pdo->lastInsertId();
        http_response_code(201);
        echo json_encode(['id' => $id, 'message' => 'Produto_ncm criado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao criar produto_ncm: ' . $e->getMessage()]);
    }
}

function updateProduto_ncm($pdo, $id) {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        http_response_code(400);
        echo json_encode(['error' => 'Dados invalidos']);
        return;
    }
    
    if (!isset($data['cod'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "cod" faltando']);
        return;
    }

    if (!isset($data['descricao'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Campo "descricao" faltando']);
        return;
    }
    if (strlen($data['descricao']) > 225) {
        http_response_code(400);
        echo json_encode(['error' => 'O campo "descricao" deve ter no maximo 225 caracteres']);
        return;
    }


    try {
        // Verifica se o produto_ncm existe
        $check = $pdo->prepare("SELECT id FROM produto_ncm WHERE id = ?");
        $check->execute([$id]);
        
        if (!$check->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Produto_ncm nao encontrado']);
            return;
        }
        
        $sql = "UPDATE produto_ncm SET `cod` = :cod, `descricao` = :descricao WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':cod' => $data['cod'], ':descricao' => $data['descricao'], ':id' => $id
        ]);
        
        echo json_encode(['message' => 'Produto_ncm atualizado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao atualizar produto_ncm: ' . $e->getMessage()]);
    }
}

function deleteProduto_ncm($pdo, $id) {
    try {
        // Verifica se o produto_ncm existe
        $check = $pdo->prepare("SELECT id FROM produto_ncm WHERE id = ?");
        $check->execute([$id]);
        
        if (!$check->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Produto_ncm nao encontrado']);
            return;
        }
        
        $stmt = $pdo->prepare("DELETE FROM produto_ncm WHERE id = ?");
        $stmt->execute([$id]);
        
        echo json_encode(['message' => 'Produto_ncm deletado com sucesso']);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao deletar produto_ncm: ' . $e->getMessage()]);
    }
}
?>